// Copyright 2000-2006 Adobe Macromedia Software LLC and its licensors. All rights reserved.

//*************** GLOBALS VARS *****************

var helpDoc = MM.HELP_behSetTextOfLayer;

//******************* BEHAVIOR FUNCTION **********************

//Passed a container id and a string, replaces container text.

function MM_setTextOfLayer(objId,x,newText) { //v9.0
  with (document) if (getElementById && ((obj=getElementById(objId))!=null))
    with (obj) innerHTML = unescape(newText);
}

MM.VERSION_MM_setTextOfLayer = 9.0; //define latest version number for behavior inspector

//******************* API **********************


//Can be used with any tag and any event

function canAcceptBehavior(){
  var retVal = false;
  var dom = dw.getDocumentDOM();
  if (dom && dom.body){
    var containers = issueUtils.getContainers(dom.body);
    if (containers.length && containers.length > 0)
      retVal = true;
  }
  return retVal;
}



//Returns a Javascript function to be inserted in HTML head with script tags.

function behaviorFunction(){
  return "MM_setTextOfLayer";
}



//Returns fn call to insert in HTML tag <TAG... onEvent='thisFn(arg)'>
//Calls escQuotes to find embedded quotes and precede them with \

function applyBehavior() {

  // Initialize msgStr and reVal to empty string.  
  var msgStr="", retVal="";
  with (document.theForm) {
    var menuIndex = menu.selectedIndex;
    var objId = document.MM_CONTAINER_IDS[menuIndex];
    msgStr = escExprStr(message.value,true);
  }

  // Handle error conditions (container with no id,
  // braces within message).
  if (objId.indexOf(MM.LABEL_Unidentified) == 0) retVal = MSG_UnnamedContainer;
  else if (msgStr == null) retVal = MSG_BadBraces;

  else {
    updateBehaviorFns("MM_setTextOfLayer");
    msgStr = msgStr.replace( /\r/g, '' );
    retVal = "MM_setTextOfLayer('" + objId + "','','" + msgStr + "')";
  }
  return retVal
}



//Passed the function call above, takes prior arguments and reloads the UI.
//Removes any escape characters "\"

function inspectBehavior(fnStr){
  // Extract the arguments from the function call.
  var argArray = extractExprStr(fnStr);

  if (argArray.length == 3) {
    // The id of the container
    var objId = argArray[0];

    // The number of containers with ids
    var numContainers = document.MM_CONTAINER_IDS.length;

    // Now check whether the container is already in the list
    var found = false;
    for (var i=0; i < numContainers; i++){ 
      if (objId == document.MM_CONTAINER_IDS[i]){
        document.theForm.menu.selectedIndex = i;
        found = true;
        break;
      }
    }
    if (!found) alert(errMsg(MSG_ContainerNotFound,objId));

    // Populate text field, converting all string expressions to 
    // {expression} etc.
    document.theForm.message.value = unescExprStr(argArray[2],true);
  }
}



//Returns a dummy function call to inform Dreamweaver the type of certain behavior
//call arguments. This information is used by DW to fixup behavior args when the
//document is moved or changed.
//
//It is passed an actual function call string generated by applyBehavior(), which
//may have a variable list of arguments, and this should return a matching mask.
//
//The return values are:
//  objId:  argument is simple object name, such as "Layer1"
//  other...: argument is ignored

function identifyBehaviorArguments(fnCallStr) {
  var argArray, retVal="", fullObjRef;;

  argArray = extractArgs(fnCallStr);
  fullObjRef = (argArray[1].indexOf(".")!=-1);
  if (argArray.length == 4) {
    retVal = (fullObjRef)?"NS4.0ref,IE4.0ref,other" : "objId,other,other";
  }
  return retVal;
}

//***************** LOCAL FUNCTIONS  ******************


//Load up the layers, set the insertion point

function initializeUI(){
  var dom = dw.getDocumentDOM();
  
  // Get all the containers in the body of the document
  // using a utility function from issue_utils.js.
  var elementArray = issueUtils.getContainers(dom.body);
  var displayNames = new Array();
  document.MM_CONTAINER_IDS = new Array();

  // As we're pushing the relevant tags into the displayNames and
  // MM_CONTAINER_IDS arrays, make a note of which ones
  // have ids and which don't. 
  for (var i=0; i < elementArray.length; i++){
    var elem = elementArray[i];
    var elemId = elem.getAttribute("id");
    if (elemId){
      displayNames.push(elem.tagName.toLowerCase() + ' "' + elemId + '"');
      document.MM_CONTAINER_IDS.push(elemId);
		}
    else {
      displayNames.push(elem.tagName.toLowerCase() + ' ' + MM.LABEL_Unidentified);
      document.MM_CONTAINER_IDS.push(MM.LABEL_Unidentified);
		}
	}

	with (document.theForm.menu) {
    for (var i=0; i < displayNames.length; i++){
      options[i] = new Option(displayNames[i]);
    }
		selectedIndex = 0;
	}
  document.theForm.message.focus(); //set focus on textbox
  document.theForm.message.select(); //set insertion point into textbox
}
